<?php
/**
 * Author Listing
 *
 * @author     RadiusTheme
 * @package    ClassifiedListing/Templates
 * @version    2.2.1.1
 */

use radiustheme\HomListi\Helper;
use Rtcl\Helpers\Functions;
use Rtcl\Helpers\Pagination;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$author  = get_user_by( 'slug', get_query_var( 'author_name' ) );
$user_id = $author->ID;

$general_settings = Functions::get_option( 'rtcl_general_settings' );
// Define the query
$paged = ! empty( $_GET['page'] ) ? intval( sanitize_text_field( $_GET['page'] ) ) : 1;
$args  = array(
	'post_type'      => rtcl()->post_type,
	'posts_per_page' => ! empty( $general_settings['listings_per_page'] ) ? absint( $general_settings['listings_per_page'] ) : 10,
	'paged'          => $paged,
	'author'         => $user_id,
	'meta_query'     => [
		[
			'key'     => '_rtcl_manager_id',
			'compare' => 'NOT EXISTS'
		]
	]
);

$user_ads_query = new \WP_Query( apply_filters( 'rtcl_user_listing_args', $args ) );

if ( $user_ads_query->have_posts() ) : ?>
    <div class="rtcl-agent-listing-list rtcl-agent-ad-listing-wrapper">
        <br>

        <ul class="mb-4">
            <li class="active">
                <a href="">
					<?php printf( esc_html__( "All ads from %s", "homlisti" ), $author->display_name ) ?>
                </a>
            </li>
        </ul>

        <div class="rtcl-listings rtcl-list-view rtcl-listing-wrapper"
             data-pagination='{"max_num_pages":<?php echo esc_attr( $user_ads_query->max_num_pages ) ?>, "current_page": 1, "found_posts":<?php echo esc_attr( $user_ads_query->found_posts ) ?>, "posts_per_page":<?php echo esc_attr( $user_ads_query->query_vars['posts_per_page'] ) ?>}'>
            <!-- the loop -->
			<?php
			while ( $user_ads_query->have_posts() ) : $user_ads_query->the_post();
				$listing = rtcl()->factory->get_listing( get_the_ID() );
				Functions::get_template_part( 'content', 'listing' );
			endwhile;
			Helper::user_archive_pagination( $user_ads_query, $paged );
			wp_reset_postdata();
			?>
            <!-- end of the loop -->

            <!-- Use reset postdata to restore original query -->
			<?php wp_reset_postdata(); ?>
        </div>
    </div>
<?php endif; ?>