<?php

/**
 *
 * @author     RadiusTheme
 * @package    classified-listing/templates
 * @version    1.0.0
 */

use radiustheme\HomListi\RDTheme;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<form id="rtcl-contact-form" class="form-vertical">

    <div class="form-group">
        <input type="text" name="name" class="form-control" id="rtcl-contact-name"
               placeholder="<?php esc_attr_e( "Name *", "homlisti" ) ?>"
               required/>
    </div>
    <div class="form-group">
        <input type="email" name="email" class="form-control" id="rtcl-contact-email"
               placeholder="<?php esc_attr_e( "Email*", "homlisti" ) ?>"
               required/>
    </div>
    <div class="form-group">
        <input type="text" name="phone" class="form-control" id="rtcl-contact-phone"
               placeholder="<?php esc_attr_e( "Phone*", "homlisti" ) ?>"
               required/>
    </div>
    <div class="form-group">
        <textarea class="form-control" name="message" id="rtcl-contact-message" rows="5" cols="20"
                  placeholder="<?php esc_attr_e( "Message*", "homlisti" ) ?>"
                  required></textarea>
    </div>
	<?php if(! empty(RDTheme::$options['listing_contact_terms_condition'])) : ?>
    <div class="form-group d-flex gap-5">
        <label class="terms-and-condition" for="rtcl-terms-condition">
            <input type="checkbox" name="terms" class="form-control" id="rtcl-terms-condition" required/>
            <?php esc_html_e( "I've read and accept the ", "homlisti" ) ?>
        </label>
        <a target="_blank" href="<?php echo esc_url(RDTheme::$options['listing_contact_terms_condition'])?>"><?php esc_html_e( "terms & condition", "homlisti" ) ?></a>
    </div>
    <?php endif; ?>
    <div id="rtcl-contact-g-recaptcha"></div>
    <p id="rtcl-contact-message-display"></p>
    <div class="form-group">
        <button type="submit"
                class="submit-btn"><?php esc_html_e( "Send Message", "homlisti" ) ?>
        </button>
    </div>
</form>